//
//  OPImageService.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 2012-10-21.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <OnePasswordCore/OnePasswordCore.h>

@class OPItem;
@protocol OPGenericProfile;

#define kImageTypeLogin @"login"
#define kImageTypeSoftware @"software"

typedef NS_ENUM(NSInteger, OPImageUsage) {
	OPImageUsageList = 0,
	OPImageUsageDetails
};

typedef void (^FetchImageBlock)(OPImage *image);

@interface OPImageService : NSObject

@property (nonatomic, readonly, getter = isEnabled) BOOL enabled;
@property (nonatomic, readonly) dispatch_queue_t callbackQueue;

+ (OPImageService *)sharedService;

#if TARGET_OS_IPHONE
+ (OPImage *)badgeImageWithFrozenBadge:(OPImage *)image;
#endif

- (void)enable;
- (void)disable;

- (OPImage *)cachedListImageForItem:(OPItem *)item scale:(CGFloat)scale;

- (NSOperation *)fetchListImageForItem:(OPItem *)item scale:(CGFloat)scale completion:(FetchImageBlock)completion;
- (NSOperation *)fetchDetailImageForItem:(OPItem *)item scale:(CGFloat)scale completion:(FetchImageBlock)completion;
- (NSOperation *)webListImageForName:(NSString *)name profile:(id<OPGenericProfile>)profile scale:(CGFloat)scale completion:(FetchImageBlock)completion;
- (NSOperation *)webDetailImageForName:(NSString *)name profile:(id<OPGenericProfile>)profile scale:(CGFloat)scale completion:(FetchImageBlock)completion;

- (OPImage *)imageForType:(NSString *)type usage:(OPImageUsage)imageUsage;

- (void)frameAndCacheImagesInFolder:(NSURL *)folder;

@end
